<?php
session_start(); // Maintenir la session pour la sidebar et le header
require_once 'config/database.php'; // Au cas où pour des configurations futures

// Pas besoin de vérifier si l'utilisateur est connecté pour une page publique,
// mais la session est utile pour l'affichage cohérent du header/sidebar.
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Nouvel Acte - Spectacles à Venir</title>
  <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
  <div class="container">
      <!-- Sidebar -->
      <?php include 'includes/sidebar.php'; ?>

      <!-- Header -->
      <header class="header">
          <div class="search-box-container"> <!-- Wrapper pour le titre ou la recherche -->
             <h1>Spectacles à Venir</h1>
          </div>
          <div class="actions">
              <?php if (isset($_SESSION['user_id'])): ?>
                <div class="icon-btn notification-btn" title="Notifications"></div>
              <?php endif; ?>
          </div>
      </header>

      <!-- Contenu principal -->
      <main class="main">
          <section class="upcoming-grid">
              <div class="cards cards-upcoming" id="upcomingCardsContainer">
                  <!-- Les cartes des spectacles à venir seront chargées ici par JavaScript -->
                  <p class="loading-message">Chargement des spectacles à venir...</p>
              </div>
          </section>
      </main>

      <!-- Sidebar droite (optionnelle, peut être enlevée ou adaptée) -->
      <aside class="aside">
          <?php if (isset($_SESSION['user_id'])): ?>
          <div class="profile">
              <img src="assets/images/avatar-placeholder.jpg" alt="Avatar"/>
              <div class="info">
                  <div><?php echo htmlspecialchars($_SESSION['user_name']); ?></div>
                  <div>@<?php echo strtolower(str_replace(' ', '', $_SESSION['user_name'])); ?></div>
              </div>
          </div>
          <?php else: ?>
            <div class="auth-prompt">
                <p>Connectez-vous pour accéder à plus de fonctionnalités !</p>
                <a href="identification.php" class="btn btn-primary">Se connecter</a>
                <a href="register.php" class="btn btn-secondary" style="margin-top:10px;">S'inscrire</a>
            </div>
          <?php endif; ?>
          <!-- Autres contenus de la sidebar droite si pertinents -->
      </aside>
  </div>

  <script src="assets/js/upcoming.js"></script>
  <script src="assets/js/main.js"></script> <!-- Pour showNotification si elle est globale -->
</body>
</html>
